﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessAHOBPR.MilitaryInfoService;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis
{
    public class BranchesOfServiceManager
    {
        public Dictionary<DateRange, string> GetRegistrantsBranchesOfService(string edipi)
        {
            var mseImporter = new MilitaryServiceEpisodeImporter();
            List<MilitaryServiceEpisode> episodes = mseImporter.GetMilitaryServiceEpisodes(edipi);
            Dictionary<DateRange, string> branchesOfService = AssociateBranchesOfServiceWithDatesServed(episodes);
            return branchesOfService;
        }
        /// <summary>
        /// Extract Branch of Service string from List of Military Episodes. If more than one episode is present, pick the last one
        /// </summary>
        /// <param name="episodes"></param>
        /// <returns></returns>
        public Dictionary<DateRange, string> AssociateBranchesOfServiceWithDatesServed(List<MilitaryServiceEpisode> episodes)
        {
            Dictionary<DateRange, string> branches = new Dictionary<DateRange, string>();
            //Check if there is more than one episode  present
            foreach (var episode in episodes)
            {
                DateRange dateRange = AHOBPRShared.CreateNewDateRange(episode.militaryServiceEpisodeData.serviceEpisodeStartDate, episode.militaryServiceEpisodeData.serviceEpisodeEndDate);
                if (!branches.ContainsKey(dateRange))
                {
                    branches.Add(dateRange, episode.militaryServiceEpisodeData?.branchOfServiceCode?.Trim());
                }
            }
            return branches;
        }
    }
}
